import { StyleSheet, Dimensions } from "react-native";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
const { width, height } = Dimensions.get("window");
const AddressStyle = StyleSheet.create({
    container: {
        paddingHorizontal: dpr(20),
        paddingTop: dpr(20),
        backgroundColor: "#fff",
        flex: 1,
        paddingBottom: dpr(70),
    },
    btnContainer: {
        backgroundColor: "#fff",
        position: "absolute",
        left: 0,
        bottom: 0,
        width: width,
        zIndex: 1,
        paddingVertical: dpr(25),
        shadowColor: "#000",
        shadowOffset: {
            width: 0,
            height: 12,
        },
        shadowOpacity: 0.6,
        elevation: 24,
    },
    btnText: {
        textAlign: "center",
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(16),
        color: "#2C2C2C",
    },

    singleAddressCont: {
        borderWidth: 1,
        borderColor: "#DFDFDF",
        borderRadius: 6,
        padding: dpr(20),
        paddingTop: dpr(10),
        paddingBottom: dpr(10),
        marginBottom: dpr(20),
    },
    defaultAddress: (is_default) => ({
        borderColor: is_default ? '#FCCA19' : '#DFDFDF',
        backgroundColor: is_default ? '#FEF8E7' : '#FFFFFF',
    }),
    defaultAddress2: (borderColor, id) => ({
        borderColor: borderColor == id ? '#FCCA19' : '#DFDFDF',
        backgroundColor: borderColor == id ? '#FEF8E7' : '#FFFFFF',
    }),
    titleCont: {
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
        width: dpr("wf") - dpr(20) * 4,
    },
    title: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(16),
        color: "#2C2C2C",
    },
    name: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(15),
        color: "#2C2C2C",
        lineHeight: dpr(25),
    },
    name2: {
        width: '57%',
    },
    phone: {
        width: '40%',
        textAlign: 'right'
    },
    address: {
        marginTop: dpr(5),
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(14),
        color: "#898989",
        lineHeight: dpr(26),
    },
    default: {
        flexDirection: "row",
        alignItems: "center",
        marginTop: dpr(2),
        height: dpr(45),
    },
    defaultText: {
        marginLeft: dpr(7),
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(12),
    },
    makeDefault: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(13),
        color: "#2C2C2C",
        textDecorationLine: "underline",
        marginRight: "auto",
    },
    noAddress: {
        flex: 1,
        justifyContent: "center",
        alignItems: "center",
        backgroundColor: "#fff",
    },
    loadMore: {
        bottom: 70
    },
    editIcon: {
        padding: dpr(10),
    },
});

export default AddressStyle;
